/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.events;

import com.direwolf20.laserio.client.renderer.LaserIOItemRenderer;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class EventTooltip {
    private static final int STACKS_PER_LINE = 5;

    private static void renderFilterStack(PoseStack matrices, ItemRenderer itemRenderer, ItemStack itemStack, int x, int y) {
        Minecraft mc = Minecraft.m_91087_();
        BlockEntityWithoutLevelRenderer blockentitywithoutlevelrenderer = new BlockEntityWithoutLevelRenderer(mc.m_167982_(), mc.m_167973_());
        LaserIOItemRenderer tooltipItemRenderer = new LaserIOItemRenderer(mc.m_91097_(), mc.m_91304_(), mc.getItemColors(), blockentitywithoutlevelrenderer);
        String s1 = Integer.toString(itemStack.m_41613_());
        int w1 = mc.f_91062_.m_92895_(s1);
        matrices.m_85836_();
        matrices.m_85841_(0.5f, 0.5f, 0.0f);
        tooltipItemRenderer.renderGuiItem(8.0f, itemStack, x, y, itemRenderer.m_174264_(itemStack, null, null, 0));
        tooltipItemRenderer.renderGuiItemDecorations(mc.f_91062_, itemStack, x, y, null, 0.5f);
        matrices.m_85849_();
    }

    private static void renderTagStack(PoseStack matrices, ItemRenderer itemRenderer, String tag, int x, int y) {
        List tagFluids;
        Minecraft mc = Minecraft.m_91087_();
        BlockEntityWithoutLevelRenderer blockentitywithoutlevelrenderer = new BlockEntityWithoutLevelRenderer(mc.m_167982_(), mc.m_167973_());
        LaserIOItemRenderer tooltipItemRenderer = new LaserIOItemRenderer(mc.m_91097_(), mc.m_91304_(), mc.getItemColors(), blockentitywithoutlevelrenderer);
        List tagItems = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation(tag))).stream().toList();
        if (tagItems.size() > 0) {
            ItemStack drawStack = new ItemStack((ItemLike)tagItems.get((int)(mc.f_91073_.m_46467_() / 20L) % tagItems.size()));
            matrices.m_85836_();
            tooltipItemRenderer.renderGuiItem(8.0f, drawStack, x, y, itemRenderer.m_174264_(drawStack, null, null, 0));
            matrices.m_85849_();
        }
        if ((tagFluids = ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)new ResourceLocation(tag))).stream().toList()).size() > 0) {
            ItemStack bucketStack;
            FluidStack drawFluidStack = new FluidStack((Fluid)tagFluids.get((int)(mc.f_91073_.m_46467_() / 20L) % tagFluids.size()), 1000);
            matrices.m_85836_();
            if (!drawFluidStack.isEmpty() && !(bucketStack = new ItemStack((ItemLike)drawFluidStack.getFluid().m_6859_(), 1)).m_41619_()) {
                tooltipItemRenderer.renderGuiItem(8.0f, bucketStack, x, y, itemRenderer.m_174264_(bucketStack, null, null, 0));
            }
            matrices.m_85849_();
        }
    }

    public static class CopyPasteTooltipComponent
    implements ClientTooltipComponent {
        Data tooltipData;

        public CopyPasteTooltipComponent(Data tooltipComponent) {
            this.tooltipData = tooltipComponent;
        }

        public int m_142103_() {
            return Screen.m_96638_() ? 10 * this.tooltipData.rows : 0;
        }

        public int m_142069_(Font font) {
            return Screen.m_96638_() && this.tooltipData.filterData != null ? 45 : 0;
        }

        public void m_183452_(Font font, int x, int y, PoseStack poseStack, ItemRenderer itemRenderer, int p_194053_) {
            if (this.tooltipData.stack == null) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null || mc.f_91074_ == null || !Screen.m_96638_()) {
                return;
            }
            if (this.tooltipData.filterData == null && this.tooltipData.tags == null) {
                return;
            }
            int bx = x - 3;
            int by = y - 6;
            int j = 0;
            RenderSystem.m_69478_();
            RenderSystem.m_69405_((int)770, (int)771);
            if (this.tooltipData.stack.m_41720_() instanceof FilterTag) {
                for (int i = 0; i < this.tooltipData.tags.size(); ++i) {
                    int xx = bx + j % 5 * 9;
                    int yy = by + j / 5 * 10;
                    String tag = this.tooltipData.tags.get(i);
                    if (!tag.isEmpty()) {
                        EventTooltip.renderTagStack(poseStack, itemRenderer, tag, xx, yy);
                    }
                    ++j;
                }
            } else {
                for (int i = 0; i < this.tooltipData.filterData.getSlots(); ++i) {
                    int xx = bx + j % 5 * 9;
                    int yy = by + j / 5 * 10;
                    ItemStack filterStack = this.tooltipData.filterData.getStackInSlot(i);
                    if (!filterStack.m_41619_()) {
                        EventTooltip.renderFilterStack(poseStack, itemRenderer, filterStack, xx, yy);
                    }
                    ++j;
                }
            }
        }

        public static class Data
        implements TooltipComponent {
            public ItemStack stack;
            public ItemStackHandler filterData;
            public List<String> tags;
            public int rows = 0;

            public Data(ItemStack stack) {
                this.stack = stack;
                if (stack.m_41720_() instanceof FilterBasic) {
                    this.filterData = FilterBasic.getInventory(stack);
                } else if (stack.m_41720_() instanceof FilterCount) {
                    this.filterData = FilterCount.getInventory(stack);
                } else if (stack.m_41720_() instanceof FilterTag) {
                    this.tags = FilterTag.getTags(stack);
                } else {
                    return;
                }
                if (stack.m_41720_() instanceof FilterTag) {
                    int itemStackMin = 0;
                    int itemStackMax = Math.min(15, this.tags.size());
                    this.tags = this.tags.subList(itemStackMin, itemStackMax);
                    this.tags.sort(Comparator.naturalOrder());
                    this.rows = (int)Math.ceil((double)this.tags.size() / 5.0);
                } else {
                    int slot;
                    for (slot = 0; slot < 5; ++slot) {
                        if (this.filterData.getStackInSlot(slot).m_41619_()) continue;
                        this.rows = 1;
                        break;
                    }
                    for (slot = 5; slot < 10; ++slot) {
                        if (this.filterData.getStackInSlot(slot).m_41619_()) continue;
                        this.rows = 2;
                        break;
                    }
                    for (slot = 10; slot < 15; ++slot) {
                        if (this.filterData.getStackInSlot(slot).m_41619_()) continue;
                        this.rows = 3;
                        break;
                    }
                }
            }
        }
    }
}

